'From Squeakland 3.8-05 of 7 September 2005 [latest update: #494] on 8 May 2007 at 9:50:18 am'!
InterpreterPlugin subclass: #KedamaPlugin2
	instanceVariableNames: 'kedamaRandomSeed randA randM randQ randR'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'EToys-StarSqueak'!

!KedamaPlugin2 methodsFor: 'predicated array primitive' stamp: 'yo 1/19/2006 16:16'!
primitivePredicateAtAllPutBoolean

	| rcvrOop valOop val valuesOop values predicatesOop predicates |

	self export: true.
	self inline: true.
	self var: #values declareC: 'unsigned char *values'.
	self var: #predicates declareC: 'unsigned char *predicates'.

	valOop _ interpreterProxy stackValue: 0.
	rcvrOop _ interpreterProxy stackObjectValue: 1.
	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isIntegerValue: valOop) ifTrue: [
		val _ interpreterProxy integerValueOf: valOop.
	] ifFalse: [
		val _ interpreterProxy booleanValueOf: valOop.
	].

	valuesOop _ interpreterProxy fetchPointer: 1 ofObject: rcvrOop.
	predicatesOop _ interpreterProxy fetchPointer: 0 ofObject: rcvrOop.
	interpreterProxy failed ifTrue: [^ nil].
	(interpreterProxy isBytes: predicatesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isBytes: valuesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	values _ interpreterProxy firstIndexableField: valuesOop.
	predicates _ interpreterProxy firstIndexableField: predicatesOop.
	
	0 to: (interpreterProxy stSizeOf: valuesOop) - 1 do:[:i |
		(predicates at: i) = 1 ifTrue: [
			values at: i put: val
		].
	].

	interpreterProxy pop: 1.
! !

!KedamaPlugin2 methodsFor: 'predicated array primitive' stamp: 'yo 10/13/2005 23:35'!
primitivePredicateAtAllPutColor

	| rcvrOop val valuesOop values predicatesOop predicates |

	self export: true.
	self inline: true.
	self var: #values declareC: 'unsigned int *values'.
	self var: #val declareC: 'unsigned int val'.
	self var: #predicates declareC: 'unsigned char *predicates'.

	val _ interpreterProxy stackIntegerValue: 0.
	rcvrOop _ interpreterProxy stackObjectValue: 1.
	interpreterProxy failed ifTrue: [^ nil].

	val _ val bitOr: 16rFF000000.

	valuesOop _ interpreterProxy fetchPointer: 1 ofObject: rcvrOop.
	predicatesOop _ interpreterProxy fetchPointer: 0 ofObject: rcvrOop.
	interpreterProxy failed ifTrue: [^ nil].
	(interpreterProxy isBytes: predicatesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: valuesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	values _ interpreterProxy firstIndexableField: valuesOop.
	predicates _ interpreterProxy firstIndexableField: predicatesOop.
	
	0 to: (interpreterProxy stSizeOf: valuesOop) - 1 do:[:i |
		(predicates at: i) = 1 ifTrue: [
			values at: i put: val
		].
	].

	interpreterProxy pop: 1.
! !

!KedamaPlugin2 methodsFor: 'predicated array primitive' stamp: 'yo 10/13/2005 23:36'!
primitivePredicateAtAllPutNumber

	| rcvrOop val valuesOop values predicatesOop predicates |

	self export: true.
	self inline: true.
	self var: #values declareC: 'float *values'.
	self var: #val declareC: 'float val'.
	self var: #predicates declareC: 'unsigned char *predicates'.

	val _ interpreterProxy stackFloatValue: 0.
	rcvrOop _ interpreterProxy stackObjectValue: 1.
	interpreterProxy failed ifTrue: [^ nil].

	valuesOop _ interpreterProxy fetchPointer: 1 ofObject: rcvrOop.
	predicatesOop _ interpreterProxy fetchPointer: 0 ofObject: rcvrOop.
	interpreterProxy failed ifTrue: [^ nil].
	(interpreterProxy isBytes: predicatesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: valuesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	values _ interpreterProxy firstIndexableField: valuesOop.
	predicates _ interpreterProxy firstIndexableField: predicatesOop.
	
	0 to: (interpreterProxy stSizeOf: valuesOop) - 1 do:[:i |
		(predicates at: i) = 1 ifTrue: [
			values at: i put: val
		].
	].

	interpreterProxy pop: 1.
! !

!KedamaPlugin2 methodsFor: 'predicated array primitive' stamp: 'yo 10/13/2005 23:33'!
primitivePredicateAtAllPutObject

	| rcvrOop valOop valuesOop values predicatesOop predicates |

	self export: true.
	self inline: true.
	self var: #values declareC: 'int *values'.
	self var: #predicates declareC: 'unsigned char *predicates'.

	valOop _ interpreterProxy stackValue: 0.
	rcvrOop _ interpreterProxy stackObjectValue: 1.
	interpreterProxy failed ifTrue: [^ nil].

	valuesOop _ interpreterProxy fetchPointer: 1 ofObject: rcvrOop.
	predicatesOop _ interpreterProxy fetchPointer: 0 ofObject: rcvrOop.
	interpreterProxy failed ifTrue: [^ nil].
	(interpreterProxy isBytes: predicatesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isPointers: valuesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	values _ interpreterProxy firstIndexableField: valuesOop.
	predicates _ interpreterProxy firstIndexableField: predicatesOop.
	
	0 to: (interpreterProxy stSizeOf: valuesOop) - 1 do:[:i |
		(predicates at: i) = 1 ifTrue: [
			values at: i put: valOop
		].
	].

	interpreterProxy pop: 1.
! !

!KedamaPlugin2 methodsFor: 'predicated array primitive' stamp: 'yo 10/14/2005 00:02'!
primitivePredicateReplaceBytes

	| rcvrOop valuesOop values predicatesOop predicates repStart repOop stop start replacement valuesSize predicatesSize replacementSize |

	self export: true.
	self inline: true.
	self var: #values declareC: 'unsigned char *values'.
	self var: #predicates declareC: 'unsigned char *predicates'.
	self var: #replacement declareC: 'unsigned char *replacement'.

	repStart _ interpreterProxy stackIntegerValue: 0.
	repOop _ interpreterProxy stackObjectValue: 1.
	stop _ interpreterProxy stackIntegerValue: 2.
	start _ interpreterProxy stackIntegerValue: 3.
	rcvrOop _ interpreterProxy stackObjectValue: 4.
	interpreterProxy failed ifTrue: [^ nil].

	valuesOop _ interpreterProxy fetchPointer: 1 ofObject: rcvrOop.
	predicatesOop _ interpreterProxy fetchPointer: 0 ofObject: rcvrOop.
	interpreterProxy failed ifTrue: [^ nil].
	(interpreterProxy isBytes: predicatesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	((interpreterProxy isBytes: valuesOop) and: [interpreterProxy isBytes: repOop])
		ifFalse: [interpreterProxy primitiveFail. ^ nil].

	values _ interpreterProxy firstIndexableField: valuesOop.
	predicates _ interpreterProxy firstIndexableField: predicatesOop.
	replacement _ interpreterProxy firstIndexableField: repOop.
	valuesSize _ interpreterProxy stSizeOf: valuesOop.
	predicatesSize _ interpreterProxy stSizeOf: predicatesOop.
	replacementSize _ interpreterProxy stSizeOf: repOop.

	start > stop ifTrue: [interpreterProxy primitiveFail. ^ nil].
	start < 1 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	start > valuesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	start > predicatesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	stop > valuesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	stop > predicatesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	repStart < 1 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	repStart > replacementSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(replacementSize - repStart + 1) < (stop - start + 1) ifTrue: [interpreterProxy primitiveFail. ^ nil].
	
	start - 1 to: stop - 1 do: [:i |
		(predicates at: i) = 1 ifTrue: [
			values at: i put: (replacement at: repStart + i - start).
		].
	].

	interpreterProxy pop: 4.
! !

!KedamaPlugin2 methodsFor: 'predicated array primitive' stamp: 'yo 1/20/2006 12:01'!
primitivePredicateReplaceWords

	| rcvrOop valuesOop values predicatesOop predicates repStart repOop stop start replacement valuesSize predicatesSize replacementSize vIsFloat rIsFloat floatValues floatReplacement fv |

	self export: true.
	self inline: true.
	self var: #values declareC: 'unsigned int *values'.
	self var: #floatValues declareC: 'float *floatValues'.
	self var: #predicates declareC: 'unsigned char *predicates'.
	self var: #replacement declareC: 'unsigned int *replacement'.
	self var: #floatReplacement declareC: 'float *floatReplacement'.
	self var: #fv declareC: 'unsigned int fv'.

	repStart _ interpreterProxy stackIntegerValue: 0.
	repOop _ interpreterProxy stackObjectValue: 1.
	stop _ interpreterProxy stackIntegerValue: 2.
	start _ interpreterProxy stackIntegerValue: 3.
	rcvrOop _ interpreterProxy stackObjectValue: 4.
	interpreterProxy failed ifTrue: [^ nil].

	valuesOop _ interpreterProxy fetchPointer: 1 ofObject: rcvrOop.
	predicatesOop _ interpreterProxy fetchPointer: 0 ofObject: rcvrOop.
	interpreterProxy failed ifTrue: [^ nil].
	(interpreterProxy isBytes: predicatesOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(((interpreterProxy isWords: valuesOop) and: [interpreterProxy isWords: repOop]) or: [
		(interpreterProxy isPointers: valuesOop) and: [interpreterProxy isPointers: repOop]]) 
			ifFalse: [interpreterProxy primitiveFail. ^ nil].

	predicates _ interpreterProxy firstIndexableField: predicatesOop.
	valuesSize _ interpreterProxy stSizeOf: valuesOop.
	predicatesSize _ interpreterProxy stSizeOf: predicatesOop.
	replacementSize _ interpreterProxy stSizeOf: repOop.

	start > stop ifTrue: [interpreterProxy primitiveFail. ^ nil].
	start < 1 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	start > valuesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	start > predicatesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	stop > valuesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	stop > predicatesSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	repStart < 1 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	repStart > replacementSize ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(replacementSize - repStart + 1) < (stop - start + 1) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	vIsFloat _ interpreterProxy is: valuesOop MemberOf: 'KedamaFloatArray'.
	rIsFloat _ interpreterProxy is: repOop MemberOf: 'KedamaFloatArray'.
	(vIsFloat and: [rIsFloat]) ifTrue: [
		floatValues _ interpreterProxy firstIndexableField: valuesOop.
		floatReplacement _  interpreterProxy firstIndexableField: repOop.
		start - 1 to: stop - 1 do: [:i |
			(predicates at: i) = 1 ifTrue: [
				floatValues at: i put: (floatReplacement at: repStart + i - start).
			].
		].
	].
	(vIsFloat and: [rIsFloat not]) ifTrue: [
		floatValues _ interpreterProxy firstIndexableField: valuesOop.
		replacement _  interpreterProxy firstIndexableField: repOop.
		start - 1 to: stop - 1 do: [:i |
			(predicates at: i) = 1 ifTrue: [
				floatValues at: i put: (replacement at: repStart + i - start).
			].
		].
	].
	(vIsFloat not and: [rIsFloat]) ifTrue: [
		values _ interpreterProxy firstIndexableField: valuesOop.
		floatReplacement _  interpreterProxy firstIndexableField: repOop.
		start - 1 to: stop - 1 do: [:i |
			(predicates at: i) = 1 ifTrue: [
				fv _ self cCoerce: (floatReplacement at: repStart + i - start) to: 'unsigned int'.
				self cCode: '' inSmalltalk: [fv _ fv asInteger].
				values at: i put: fv.
			].
		].
	].
	(vIsFloat not and: [rIsFloat not]) ifTrue: [
		values _ interpreterProxy firstIndexableField: valuesOop.
		replacement _  interpreterProxy firstIndexableField: repOop.
		start - 1 to: stop - 1 do: [:i |
			(predicates at: i) = 1 ifTrue: [
				values at: i put: (replacement at: repStart + i - start).
			].
		].
	].

	interpreterProxy pop: 4.
! !


!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveAddArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg wordsResult floatsArg floatsResult floatsRcvr |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgWords & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) + (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) + (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) + (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) + (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveAddScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr wordsResult floatsResult floatsRcvr isArgInt intArg floatArg |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgInt & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) + intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) + floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) + intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) + floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 1/19/2006 20:20'!
primitiveAndByteArray

	| length rcvrOop otherOop otherArray rcvrArray length1 length2 |

	self export: true.
	self inline: true.
	self var: #rcvrArray declareC: 'unsigned char *rcvrArray'.
	self var: #otherArray declareC: 'unsigned char *otherArray'.

	otherOop _ interpreterProxy stackObjectValue: 0.
	rcvrOop _ interpreterProxy stackValue: 1.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isBytes: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: otherOop).
	interpreterProxy failed ifTrue:[^nil].
	length1 _ interpreterProxy stSizeOf: rcvrOop.
	length2 _ interpreterProxy stSizeOf: otherOop.
	interpreterProxy failed ifTrue:[^nil].
	length _ length1.
	length1 > length2 ifTrue: [
		length _ length2.
	].

	otherArray _ interpreterProxy firstIndexableField: otherOop.
	rcvrArray _ interpreterProxy firstIndexableField: rcvrOop.
	0 to: length-1 do:[:i|
		rcvrArray at: i put: (((rcvrArray at: i) + (otherArray at: i)) = 2).
	].
	interpreterProxy pop: 1.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveDivArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg wordsResult floatsArg floatsResult floatsRcvr |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgWords & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) / (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) / (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) / (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) / (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveDivScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr wordsResult floatsResult floatsRcvr isArgInt intArg floatArg |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgInt & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) // intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) / floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) / intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) / floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 20:58'!
primitiveEQArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg floatsArg floatsRcvr bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) = (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) = (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) = (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) = (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 20:58'!
primitiveEQScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr floatsRcvr isArgInt intArg floatArg bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) = intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) = floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) = intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) = floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 21:05'!
primitiveGEArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg floatsArg floatsRcvr bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) >= (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) >= (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) >= (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) >= (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 21:06'!
primitiveGEScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr floatsRcvr isArgInt intArg floatArg bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) >= intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) >= floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) >= intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) >= floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 21:05'!
primitiveGTArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg floatsArg floatsRcvr bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) > (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) > (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) > (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) > (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 21:04'!
primitiveGTScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr floatsRcvr isArgInt intArg floatArg bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) > intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) > floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) > intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) > floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 20:49'!
primitiveLEArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg floatsArg floatsRcvr bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) <= (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) <= (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) <= (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) <= (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 20:49'!
primitiveLEScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr floatsRcvr isArgInt intArg floatArg bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) <= intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) <= floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) <= intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) <= floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 20:42'!
primitiveLTArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg floatsArg floatsRcvr bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) < (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) < (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) < (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) < (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 20:41'!
primitiveLTScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr floatsRcvr isArgInt intArg floatArg bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) < intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) < floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) < intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) < floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveMulArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg wordsResult floatsArg floatsResult floatsRcvr |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgWords & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) * (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) * (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) * (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) * (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveMulScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr wordsResult floatsResult floatsRcvr isArgInt intArg floatArg |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgInt & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) * intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) * floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) * intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) * floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 21:11'!
primitiveNEArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg floatsArg floatsRcvr bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) ~= (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) ~= (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) ~= (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) ~= (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 21:11'!
primitiveNEScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr floatsRcvr isArgInt intArg floatArg bytesResult |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #bytesResult declareC: 'unsigned char *bytesResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) ~= intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (wordsRcvr at: i) ~= floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) ~= intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			bytesResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				bytesResult at: i put: (floatsRcvr at: i) ~= floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 17:49'!
primitiveNotByteArray

	| length rcvrOop rcvrArray |

	self export: true.
	self inline: true.
	self var: #rcvrArray declareC: 'unsigned char *rcvrArray'.

	rcvrOop _ interpreterProxy stackValue: 0.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isBytes: rcvrOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy failed ifTrue:[^nil].

	rcvrArray _ interpreterProxy firstIndexableField: rcvrOop.
	0 to: length-1 do:[:i|
		(rcvrArray at: i) = 0 ifTrue: [
			rcvrArray at: i put: 1
		] ifFalse: [
			rcvrArray at: i put: 0
		].
	].
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 1/19/2006 20:17'!
primitiveOrByteArray

	| length rcvrOop otherOop otherArray rcvrArray length1 length2 |

	self export: true.
	self inline: true.
	self var: #rcvrArray declareC: 'unsigned char *rcvrArray'.
	self var: #otherArray declareC: 'unsigned char *otherArray'.

	otherOop _ interpreterProxy stackObjectValue: 0.
	rcvrOop _ interpreterProxy stackValue: 1.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isBytes: rcvrOop).
	interpreterProxy success: (interpreterProxy isBytes: otherOop).
	interpreterProxy failed ifTrue:[^nil].
	length1 _ interpreterProxy stSizeOf: rcvrOop.
	length2 _ interpreterProxy stSizeOf: otherOop.
	interpreterProxy failed ifTrue:[^nil].
	length _ length1.
	length1 > length2 ifTrue: [
		length _ length2.
	].

	otherArray _ interpreterProxy firstIndexableField: otherOop.
	rcvrArray _ interpreterProxy firstIndexableField: rcvrOop.
	0 to: length-1 do:[:i|
		rcvrArray at: i put: (((rcvrArray at: i) + (otherArray at: i)) > 0).
	].
	interpreterProxy pop: 1.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 1/21/2006 00:21'!
primitiveRemArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg wordsResult floatsArg floatsResult floatsRcvr wordRcvr wordArg wordResult floatArg floatResult floatRcvr |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.
	self var: #floatResult declareC: 'double floatResult'.
	self var: #wordResult declareC: 'unsigned int wordResult'.
	self var: #floatRcvr declareC: 'double floatRcvr'.
	self var: #floatArg declareC: 'double floatArg'.
	self var: #wordRcvr declareC: 'unsigned int wordRcvr'.
	self var: #wordArg declareC: 'unsigned int wordArg'.


	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgWords & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordRcvr _ (wordsRcvr at: i).
				wordArg _ (wordsArg at: i).
				wordResult _ wordRcvr \\ wordArg.
				"In this primitive, words are supposed to be unsigned."
				wordsResult at: i put: wordResult.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordRcvr _ wordsRcvr at: i.
				floatArg _ floatsArg at: i.
				floatResult _ wordRcvr / floatArg.
				floatResult _ self cCode: 'floor(floatResult)' inSmalltalk: [floatResult floor].
				floatsResult at: i put: wordRcvr - (floatResult * floatArg).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatRcvr _ floatsRcvr at: i.
				wordArg _ wordsArg at: i.
				floatResult _ floatRcvr / wordArg.
				floatResult _ self cCode: 'floor(floatResult)' inSmalltalk: [floatResult floor].
				floatsResult at: i put: (floatRcvr - (floatResult * wordArg)).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatRcvr _ floatsRcvr at: i.
				floatArg _ floatsArg at: i.
				floatResult _ floatRcvr / floatArg.
				floatResult _ self cCode: 'floor(floatResult)' inSmalltalk: [floatResult floor].
				floatsResult at: i put: (floatRcvr - (floatResult * floatArg)).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 1/21/2006 00:21'!
primitiveRemScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr wordsResult floatsResult floatsRcvr isArgInt intArg floatArg wordRcvr floatResult floatRcvr |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.
	self var: #floatResult declareC: 'double floatResult'.
	self var: #wordResult declareC: 'unsigned int wordResult'.
	self var: #floatRcvr declareC: 'double floatRcvr'.
	self var: #floatArg declareC: 'double floatArg'.
	self var: #wordRcvr declareC: 'unsigned int wordRcvr'.
	self var: #wordArg declareC: 'unsigned int wordArg'.


	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgInt & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) \\ intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordRcvr _ wordsRcvr at: i.
				floatResult _ wordRcvr / floatArg.
				floatResult _ self cCode: 'floor(floatResult)' inSmalltalk: [floatResult floor].
				floatsResult at: i put: wordRcvr - (floatResult * floatArg).
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatRcvr _ floatsRcvr at: i.
				floatResult _ floatRcvr / intArg.
				floatResult _ self cCode: 'floor(floatResult)' inSmalltalk: [floatResult floor].
				floatsResult at: i put: floatRcvr - (floatResult * intArg).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatRcvr _ floatsRcvr at: i.
				floatResult _ floatRcvr / floatArg.
				floatResult _ self cCode: 'floor(floatResult)' inSmalltalk: [floatResult floor].
				floatsResult at: i put: floatRcvr - (floatResult * floatArg).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveSubArrays

	| length resultOop argOop rcvrOop isArgWords isRcvrWords wordsRcvr wordsArg wordsResult floatsArg floatsResult floatsRcvr |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #wordsArg declareC: 'unsigned int *wordsArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatsArg declareC: 'float *floatsArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackObjectValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: argOop).
	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: argOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: rcvrOop)).
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgWords _ interpreterProxy is: argOop MemberOf: 'WordArray'.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgWords & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgWords ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) - (wordsArg at: i).
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) - (floatsArg at: i).
			].
		].
	] ifFalse: [
		isArgWords ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			wordsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) - (wordsArg at: i).
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatsArg _ interpreterProxy firstIndexableField: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) - (floatsArg at: i).
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !

!KedamaPlugin2 methodsFor: 'array arithmetic' stamp: 'yo 10/13/2005 01:28'!
primitiveSubScalar

	| length resultOop argOop rcvrOop isRcvrWords wordsRcvr wordsResult floatsResult floatsRcvr isArgInt intArg floatArg |

	self export: true.
	self inline: true.
	self var: #wordsRcvr declareC: 'unsigned int *wordsRcvr'.
	self var: #intArg declareC: 'int intArg'.
	self var: #wordsResult declareC: 'unsigned int *wordsResult'.
	self var: #floatsRcvr declareC: 'float *floatsRcvr'.
	self var: #floatArg declareC: 'double floatArg'.
	self var: #floatsResult declareC: 'float *floatsResult'.

	resultOop _ interpreterProxy stackObjectValue: 0.
	argOop _ interpreterProxy stackValue: 1.
	rcvrOop _ interpreterProxy stackObjectValue: 2.
	interpreterProxy failed ifTrue:[^nil].

	interpreterProxy success: (interpreterProxy isWords: rcvrOop).
	interpreterProxy success: (interpreterProxy isWords: resultOop).
	interpreterProxy failed ifTrue:[^nil].
	length _ interpreterProxy stSizeOf: rcvrOop.
	interpreterProxy success: (length = (interpreterProxy stSizeOf: resultOop)).
	interpreterProxy failed ifTrue:[^nil].

	isArgInt _ interpreterProxy isIntegerObject: argOop.
	isRcvrWords _ interpreterProxy is: rcvrOop MemberOf: 'WordArray'.

	isArgInt & isRcvrWords ifTrue: [
		(interpreterProxy is: resultOop MemberOf: 'WordArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	] ifFalse: [
		(interpreterProxy is: resultOop MemberOf: 'KedamaFloatArray') ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	isRcvrWords ifTrue: [
		isArgInt ifTrue: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			wordsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				wordsResult at: i put: (wordsRcvr at: i) - intArg.
			].
		] ifFalse: [
			wordsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (wordsRcvr at: i) - floatArg.
			].
		].
	] ifFalse: [
		isArgInt ifTrue: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			intArg _ interpreterProxy integerValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) - intArg.
			].
		] ifFalse: [
			floatsRcvr _ interpreterProxy firstIndexableField: rcvrOop.
			floatArg _ interpreterProxy floatValueOf: argOop.
			floatsResult _ interpreterProxy firstIndexableField: resultOop.
			0 to: length-1 do:[:i|
				floatsResult at: i put: (floatsRcvr at: i) - floatArg.
			].
		].
	].

	interpreterProxy pop: 4.
	interpreterProxy push: resultOop.
! !


!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
degreesFromX: x y: y

	| tanVal theta |
	self inline: true.
	self returnTypeC: 'double'.
	self var: 'x' declareC: 'double x'.
	self var: 'y' declareC: 'double y'.
	self var: 'tanVal' declareC: 'double tanVal'.
	self var: 'theta' declareC: 'double theta'.

	x = 0.0 ifTrue: [
		y >= 0.0 ifTrue: [^ 90.0] ifFalse: [^ 270.0].
	] ifFalse: [
		tanVal _ y / x.
		theta _ self cCode: 'atan(tanVal)' inSmalltalk: [tanVal arcTan].
		x >= 0.0 ifTrue: [
			y >= 0.0
				ifTrue: [^ theta / 0.0174532925199433]
				ifFalse: [^ 360.0 + (theta / 0.0174532925199433)]
		] ifFalse: [
			^ 180.0 + (theta / 0.0174532925199433)
		]
	].
	^ 0.0.

! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
degreesToRadians: degrees

	| headingRadians deg q |
	self inline: true.
	self returnTypeC: 'double'.
	self var: 'degrees' declareC: 'double degrees'.
	self var: 'deg' declareC: 'double deg'.
	self var: 'headingRadians' declareC: 'double headingRadians'.
	self var: 'q' declareC: 'int q'.

	deg _ 90.0 - degrees.
	q _ deg / 360.0.
	deg < 0.0 ifTrue: [q _ q - 1].
	headingRadians _ (deg - (q * 360.0)) * 0.0174532925199433.
	^ headingRadians.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
drawTurtlesInArray

	| visibleArray colorArray yArray xArray destHeight destWidth destBits size x y visible visibleOop colorOop yOop xOop destOop bitsIndex |
	self export: true.
	self inline: true.
	self var: 'destBits' declareC: 'unsigned int *destBits'.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'colorArray' declareC: 'unsigned int *colorArray'.
	self var: 'visibleArray' declareC: 'unsigned char *visibleArray'.

	visibleOop _ interpreterProxy stackValue: 0.
	colorOop _ interpreterProxy stackValue: 1.
	yOop _ interpreterProxy stackValue: 2.
	xOop _ interpreterProxy stackValue: 3.
	destHeight _ interpreterProxy stackIntegerValue: 4.
	destWidth _ interpreterProxy stackIntegerValue: 5.
	destOop _ interpreterProxy stackValue: 6.

	interpreterProxy failed ifTrue: [^ nil].


	(interpreterProxy isWords: destOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: colorOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isBytes: visibleOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	(destHeight * destWidth) ~= (interpreterProxy slotSizeOf: destOop) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: xOop.
	(interpreterProxy slotSizeOf: yOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: colorOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: visibleOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	xArray _ interpreterProxy firstIndexableField: xOop.
	yArray _ interpreterProxy firstIndexableField: yOop.
	colorArray _ interpreterProxy firstIndexableField: colorOop.
	visibleArray _ interpreterProxy firstIndexableField: visibleOop.
	destBits _ interpreterProxy firstIndexableField: destOop.

	0 to: size - 1 do: [:i |
		x _ self cCoerce: (xArray at: i) to: 'int'.
		self cCode: '' inSmalltalk: [x _ x asInteger].
		y _ self cCoerce: (yArray at: i) to: 'int'.
		self cCode: '' inSmalltalk: [y _ y asInteger].
		visible _ (visibleArray at: i).
		((visible ~= 0) and: [((x >= 0) and: [y >= 0]) and: [(x < destWidth) and: [y < destHeight]]]) ifTrue: [
			bitsIndex _ ((y * destWidth) + x).
			destBits at: bitsIndex put: (colorArray at: i).
		]
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 7.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
getHeadingArrayInto

	| resultOop headingOop size headingArray resultArray heading |
	self export: true.
	self inline: true.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'resultArray' declareC: 'float *resultArray'.
	self var: 'heading' declareC: 'double heading'.

	resultOop _ interpreterProxy stackValue: 0.
	headingOop _ interpreterProxy stackValue: 1.
	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: resultOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: headingOop.
	(interpreterProxy slotSizeOf: resultOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	headingArray _ interpreterProxy firstIndexableField: headingOop.
	resultArray _ interpreterProxy firstIndexableField: resultOop.

	0 to: size - 1 do: [:i |
		heading _ headingArray at: i.
		heading _ heading / 0.0174532925199433.
		heading _ 90.0 - heading.
		heading > 0.0 ifFalse: [heading _ heading + 360.0].
		resultArray at: i put: heading.
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 2.

	! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
getScalarHeading

	| headingOop headingArray heading index |
	self export: true.
	self inline: true.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'heading' declareC: 'double heading'.

	headingOop _ interpreterProxy stackValue: 0.
	index _ interpreterProxy stackIntegerValue: 1.
	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	(interpreterProxy slotSizeOf: headingOop) < index ifTrue: [interpreterProxy primitiveFail. ^ nil].

	headingArray _ interpreterProxy firstIndexableField: headingOop.

	heading _ headingArray at: index - 1.
	heading _ self radiansToDegrees: heading.

	interpreterProxy failed ifTrue: [^ nil].

	interpreterProxy pop: 3.
	interpreterProxy pushFloat: heading.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
initialiseModule

	self export: true.
	kedamaRandomSeed _ 17.

	randA := 16r000041A7.    " magic constant =      16807 "
	randM := 16r7FFFFFFF.    " magic constant = 2147483647 "
	randQ := randM // randA.
	randR  := randM \\ randA.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
kedamaRandom2: range

	| lo hi r v val |
	self inline: true.
	range < 0 ifTrue: [r _ 0 - range] ifFalse: [r _ range].
	hi _ kedamaRandomSeed // randQ.
	lo _ kedamaRandomSeed \\ randQ. 
	kedamaRandomSeed _ (randA * lo) - (randR * hi).
	v _ kedamaRandomSeed bitAnd: 65535.
	val _ (v * (r + 1)) >> 16.
	range < 0 ifTrue: [^ 0 - val] ifFalse: [^ val].
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
kedamaRandom: range

	| r val |
	self inline: true.
	range < 0 ifTrue: [r _ 0 - range] ifFalse: [r _ range].
	kedamaRandomSeed _ ((kedamaRandomSeed * 1309) + 13849) bitAnd: 65535.
	val _ (kedamaRandomSeed * (r + 1)) >> 16.
	range < 0 ifTrue: [^ 0 - val] ifFalse: [^ val].
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
kedamaSetRandomSeed

	| seed |
	self inline: true.
	self export: true.
	seed _ interpreterProxy stackIntegerValue: 0.
	interpreterProxy failed ifTrue: [^ nil].

	kedamaRandomSeed _ seed bitAnd: 65536.

	interpreterProxy pop: 1.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
makeMask

	| shiftAmount pixel maskBits dataBits dataSize maskSize dOrigin mOrigin data alpha highMask |

	self export: true.
	self inline: true.
	self var: 'dOrigin' declareC: 'unsigned int* dOrigin'.
	self var: 'mOrigin' declareC: 'unsigned int* mOrigin'.
	self var: 'highMask' declareC: 'unsigned int highMask'.
	self var: 'alpha' declareC: 'unsigned int alpha'.
	self var: 'pixel' declareC: 'unsigned int pixel'.

	shiftAmount _ interpreterProxy stackIntegerValue: 0.
	pixel _ interpreterProxy stackIntegerValue: 1.
	maskBits _ interpreterProxy stackValue: 2.
	dataBits _ interpreterProxy stackValue: 3.

	interpreterProxy failed ifTrue: [^ nil].

	dataSize _ interpreterProxy slotSizeOf: dataBits.
	maskSize _ interpreterProxy slotSizeOf: maskBits.

	dataSize = maskSize ifFalse: [interpreterProxy primitiveFail. ^ nil].
	shiftAmount < -32 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	shiftAmount > 8 ifTrue: [interpreterProxy primitiveFail. ^ nil].

	dOrigin _ interpreterProxy firstIndexableField: dataBits.
	mOrigin _ interpreterProxy firstIndexableField: maskBits.

	highMask _ 16rFF000000.
	0 to: dataSize -1 do: [:i |
		data _ dOrigin at: i.
		alpha _ data bitShift: shiftAmount.
		(alpha > 255) ifTrue: [alpha _ 255].
		(alpha < 0) ifTrue: [alpha _ 0].
		mOrigin at: i put: (((alpha << 24) bitAnd: highMask) bitOr: pixel).
	].

	interpreterProxy pop: 4.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
makeMaskLog

	| max pixel maskBits dataBits dataSize maskSize dOrigin mOrigin data alpha highMask maxLog maxOop maxFirst |

	self export: true.
	self inline: true.
	self var: 'dOrigin' declareC: 'unsigned int* dOrigin'.
	self var: 'mOrigin' declareC: 'unsigned int* mOrigin'.
	self var: 'highMask' declareC: 'unsigned int highMask'.
	self var: 'maxFirst' declareC: 'unsigned int* maxFirst'.
	self var: 'max' declareC: 'unsigned int max'.
	self var: 'alpha' declareC: 'unsigned int alpha'.
	self var: 'pixel' declareC: 'unsigned int pixel'.
	self var: 'maxLog' declareC: 'double maxLog'.

	maxOop _ interpreterProxy stackValue: 0.
	pixel _ interpreterProxy stackIntegerValue: 1.
	maskBits _ interpreterProxy stackValue: 2.
	dataBits _ interpreterProxy stackValue: 3.

	interpreterProxy failed ifTrue: [^ nil].

	maxFirst _ (interpreterProxy firstIndexableField: maxOop).
	max _ maxFirst at: 0.

	interpreterProxy failed ifTrue: [^ nil].

	maxLog _ self cCode: 'log(max)' inSmalltalk: [max ln].

	dataSize _ interpreterProxy slotSizeOf: dataBits.
	maskSize _ interpreterProxy slotSizeOf: maskBits.

	dataSize = maskSize ifFalse: [interpreterProxy primitiveFail. ^ nil].

	dOrigin _ interpreterProxy firstIndexableField: dataBits.
	mOrigin _ interpreterProxy firstIndexableField: maskBits.

	highMask _ 16rFF000000.
	0 to: dataSize -1 do: [:i |
		data _ dOrigin at: i.
		data = 0 ifTrue: [alpha _ 0] ifFalse: [
			alpha _ ((255.0 / maxLog) * (self cCode: 'log(data)' inSmalltalk: [data ln])) asInteger.
		].
		(alpha > 255) ifTrue: [alpha _ 255].
		mOrigin at: i put: (((alpha << 24) bitAnd: highMask) bitOr: pixel).
	].

	interpreterProxy pop: 4.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
makeTurtlesMap

	| height width yOop xOop whoOop mapOop size xArray yArray whoArray map x y mapIndex |
	self export: true.
	self inline: true.

	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'whoArray' declareC: 'unsigned int *whoArray'.
	self var: 'map' declareC: 'unsigned int *map'.

	height _ interpreterProxy stackIntegerValue: 0.
	width _ interpreterProxy stackIntegerValue: 1.
	yOop _ interpreterProxy stackValue: 2.
	xOop _ interpreterProxy stackValue: 3.
	whoOop _ interpreterProxy stackValue: 4.
	mapOop _ interpreterProxy stackValue: 5.

	(interpreterProxy isWords: yOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: whoOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: mapOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: whoOop.
	(interpreterProxy slotSizeOf: xOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: yOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: mapOop) ~= (height * width) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	xArray _ interpreterProxy firstIndexableField: xOop.
	yArray _ interpreterProxy firstIndexableField: yOop.
	whoArray _ interpreterProxy firstIndexableField: whoOop.
	map _ interpreterProxy firstIndexableField: mapOop.
	
	0 to: (height * width) - 1 do: [:index |
		map at: index put: 0.
	].

	0 to: size - 1 do: [:index |
		x _ xArray at: index.
		y _ yArray at: index.
		mapIndex _ (width * y) + x.
		(mapIndex >= 0  and: [mapIndex < (height * width)]) ifTrue: [
			map at: mapIndex put: (whoArray at: index).
		].
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 6.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
primPixelAtXY

	| height width yPos xPos bitsOop x y bits index ret |
	self export: true.
	self inline: true.

	self var: 'bits' declareC: 'unsigned int *bits'.
	self var: 'xPos' declareC: 'double xPos'.
	self var: 'yPos' declareC: 'double yPos'.

	height _ interpreterProxy stackIntegerValue: 0.
	width _ interpreterProxy stackIntegerValue: 1.
	yPos _ interpreterProxy stackFloatValue: 2.
	xPos _ interpreterProxy stackFloatValue: 3.
	bitsOop _ interpreterProxy stackValue: 4.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: bitsOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: bitsOop) ~= (height * width) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	x _ xPos.
	y _ yPos.
	bits _ interpreterProxy firstIndexableField: bitsOop.

	((x >= 0) &  (x < width) & (y >= 0) & (y < height)) ifTrue: [
		index _ y * width + x.
		ret _ bits at: index.
	] ifFalse: [
		ret _ 0.
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 6.
	interpreterProxy pushInteger: ret.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
primPixelAtXYPut

	| height width value yPos xPos bitsOop x y v bits index |
	self export: true.
	self inline: true.

	self var: 'bits' declareC: 'unsigned int *bits'.
	self var: 'xPos' declareC: 'double xPos'.
	self var: 'yPos' declareC: 'double yPos'.

	height _ interpreterProxy stackIntegerValue: 0.
	width _ interpreterProxy stackIntegerValue: 1.
	value _ interpreterProxy stackIntegerValue: 2.
	yPos _ interpreterProxy stackFloatValue: 3.
	xPos _ interpreterProxy stackFloatValue: 4.
	bitsOop _ interpreterProxy stackValue: 5.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: bitsOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: bitsOop) ~= (height * width) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	x _ xPos.
	y _ yPos.
	v _ value.
	v > 16r3FFFFFFF ifTrue: [
		v _ 16r3FFFFFFF.
	].
	v < 0 ifTrue: [
		v _ 0.
	].

	bits _ interpreterProxy firstIndexableField: bitsOop.

	((x >= 0) &  (x < width) & (y >= 0) & (y < height)) ifTrue: [
		index _ y * width + x.
		bits at: index put: v.
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 6.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
primPixelsAtXY

	| yArray xArray bitsHeight bitsWidth bitsOop bits size x y bitsIndex destWordsOop  yArrayOop xArrayOop destWords  |
	self export: true.
	self inline: true.
	self var: 'destWords' declareC: 'unsigned int *destWords'.
	self var: 'bits' declareC: 'unsigned int *bits'.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.

	destWordsOop _ interpreterProxy stackValue: 0.
	bitsHeight _ interpreterProxy stackIntegerValue: 1.
	bitsWidth _ interpreterProxy stackIntegerValue: 2.
	bitsOop _ interpreterProxy stackValue: 3.
	yArrayOop _ interpreterProxy stackValue: 4.
	xArrayOop _ interpreterProxy stackValue: 5.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: destWordsOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: bitsOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	(bitsHeight * bitsWidth) ~= (interpreterProxy slotSizeOf: bitsOop) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: xArrayOop.
	(interpreterProxy slotSizeOf: yArrayOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: destWordsOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	xArray _ interpreterProxy firstIndexableField: xArrayOop.
	yArray _ interpreterProxy firstIndexableField: yArrayOop.
	destWords _ interpreterProxy firstIndexableField: destWordsOop.
	bits _ interpreterProxy firstIndexableField: bitsOop.

	0 to: size - 1 do: [:i |
		x _ self cCoerce: (xArray at: i) to: 'int'.
		self cCode: '' inSmalltalk: [x _ x asInteger].
		y _ self cCoerce: (yArray at: i) to: 'int'.
		self cCode: '' inSmalltalk: [y _ y asInteger].
		(((x >= 0) and: [y >= 0]) and: [(x < bitsWidth) and: [y < bitsHeight]]) ifTrue: [
			bitsIndex _ ((y * bitsWidth) + x).
			destWords at: i put: (bits at: bitsIndex).
		]
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 6.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
primScalarForward

	| bottomEdgeMode topEdgeMode rightEdgeMode leftEdgeMode destHeight destWidth headingOop yOop xOop size xArray yArray headingArray val dist newX newY index i |
	self export: true.
	self inline: true.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'val' declareC: 'double val'.
	self var: 'destHeight' declareC: 'double destHeight'.
	self var: 'destWidth' declareC: 'double destWidth'.
	self var: 'dist' declareC: 'double dist'.
	self var: 'newX' declareC: 'double newX'.
	self var: 'newY' declareC: 'double newY'.

	bottomEdgeMode _ interpreterProxy stackIntegerValue: 0.
	topEdgeMode _ interpreterProxy stackIntegerValue: 1.
	rightEdgeMode _ interpreterProxy stackIntegerValue: 2.
	leftEdgeMode _ interpreterProxy stackIntegerValue: 3.
	destHeight _ interpreterProxy stackFloatValue: 4.
	destWidth _ interpreterProxy stackFloatValue: 5.
	val _ interpreterProxy stackFloatValue: 6.
	headingOop _ interpreterProxy stackValue: 7.
	yOop _ interpreterProxy stackValue: 8.
	xOop _ interpreterProxy stackValue: 9.
	index _ interpreterProxy stackIntegerValue: 10.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: xOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: xOop.
	(interpreterProxy slotSizeOf: yOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: headingOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	xArray _ interpreterProxy firstIndexableField: xOop.
	yArray _ interpreterProxy firstIndexableField: yOop.
	headingArray _ interpreterProxy firstIndexableField: headingOop.

	dist _ val.
	i _ index - 1.
	newX _ (xArray at: i) + (dist * (headingArray at: i) cos).
	newY _ (yArray at: i) - (dist * (headingArray at: i) sin).
	self scalarXAt: i xArray: xArray headingArray: headingArray value: newX destWidth: destWidth leftEdgeMode: leftEdgeMode rightEdgeMode: rightEdgeMode.
	self scalarYAt: i yArray: yArray headingArray: headingArray value: newY destHeight: destHeight topEdgeMode: topEdgeMode bottomEdgeMode: bottomEdgeMode.

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 11.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 1/20/2006 14:02'!
primSetPixelsAtXY

	| yArray xArray bitsHeight bitsWidth bitsOop bits size x y bitsIndex  yArrayOop xArrayOop  valueOop isValueInt isValueWordArray intValue wordsValue value pArrayOop pArray floatsValue fv |
	self export: true.
	self inline: true.	
	self var: 'intValue' declareC: 'unsigned int intValue'.
	self var: 'wordsValue' declareC: 'unsigned int *wordsValue'.
	self var: 'floatsValue' declareC: 'float *floatsValue'.
	self var: 'value' declareC: 'unsigned int value'.
	self var: 'floatValue' declareC: 'float floatValue'.
	self var: 'bits' declareC: 'unsigned int *bits'.
	self var: 'pArray' declareC: 'unsigned char *pArray'.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.

	valueOop _ interpreterProxy stackValue: 0.
	bitsHeight _ interpreterProxy stackIntegerValue: 1.
	bitsWidth _ interpreterProxy stackIntegerValue: 2.
	bitsOop _ interpreterProxy stackValue: 3.
	yArrayOop _ interpreterProxy stackValue: 4.
	xArrayOop _ interpreterProxy stackValue: 5.
	pArrayOop _ interpreterProxy stackValue: 6.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isBytes: pArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: bitsOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	(bitsHeight * bitsWidth) ~= (interpreterProxy slotSizeOf: bitsOop) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: xArrayOop.
	(interpreterProxy slotSizeOf: pArrayOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: yArrayOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	pArray _ interpreterProxy firstIndexableField: pArrayOop.
	xArray _ interpreterProxy firstIndexableField: xArrayOop.
	yArray _ interpreterProxy firstIndexableField: yArrayOop.

	isValueInt _ interpreterProxy isIntegerObject: valueOop.
	isValueInt ifTrue: [
		intValue _ interpreterProxy integerValueOf: valueOop.
		value _ intValue.
	] ifFalse: [
		(interpreterProxy slotSizeOf: valueOop) ~= size
			ifTrue: [interpreterProxy primitiveFail. ^ nil].
		isValueWordArray _ (interpreterProxy is: valueOop MemberOf: 'WordArray').
		isValueWordArray ifTrue: [
			wordsValue _ interpreterProxy firstIndexableField: valueOop.
		] ifFalse: [
			floatsValue _ interpreterProxy firstIndexableField: valueOop.
		].
	].
	bits _ interpreterProxy firstIndexableField: bitsOop.

	0 to: size - 1 do: [:i |
		(pArray at: i) = 1 ifTrue: [
			x _ self cCoerce: (xArray at: i) to: 'int'.
			self cCode: '' inSmalltalk: [x _ x asInteger].
			y _ self cCoerce: (yArray at: i) to: 'int'.
			self cCode: '' inSmalltalk: [y _ y asInteger].
			(((x >= 0) and: [y >= 0]) and: [(x < bitsWidth) and: [y < bitsHeight]]) ifTrue: [
				bitsIndex _ ((y * bitsWidth) + x).
				isValueInt ifFalse: [
					isValueWordArray ifTrue: [
						bits at: bitsIndex put: (wordsValue at: i).
					] ifFalse: [
						fv _ floatsValue at: i.
						self cCode: '' inSmalltalk: [fv _ fv asInteger].
						bits at: bitsIndex put: fv.
					].
				] ifTrue: [
					bits at: bitsIndex put: value.
				].
			]
		].
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 7.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 15:47'!
primTurtlesForward

	| bottomEdgeMode topEdgeMode rightEdgeMode leftEdgeMode destHeight destWidth valOop headingOop yOop xOop isValVector size xArray yArray headingArray valArray val dist newX newY pOop pArray |
	self export: true.
	self inline: true.
	self var: 'pArray' declareC: 'unsigned char *pArray'.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'valArray' declareC: 'float *valArray'.
	self var: 'val' declareC: 'double val'.
	self var: 'destHeight' declareC: 'double destHeight'.
	self var: 'destWidth' declareC: 'double destWidth'.
	self var: 'dist' declareC: 'double dist'.
	self var: 'newX' declareC: 'double newX'.
	self var: 'newY' declareC: 'double newY'.

	bottomEdgeMode _ interpreterProxy stackIntegerValue: 0.
	topEdgeMode _ interpreterProxy stackIntegerValue: 1.
	rightEdgeMode _ interpreterProxy stackIntegerValue: 2.
	leftEdgeMode _ interpreterProxy stackIntegerValue: 3.
	destHeight _ interpreterProxy stackFloatValue: 4.
	destWidth _ interpreterProxy stackFloatValue: 5.
	valOop _ interpreterProxy stackValue: 6.
	headingOop _ interpreterProxy stackValue: 7.
	yOop _ interpreterProxy stackValue: 8.
	xOop _ interpreterProxy stackValue: 9.
	pOop _ interpreterProxy stackValue: 10.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isBytes: pOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isFloatObject: valOop) ifTrue: [
		isValVector _ false.
	] ifFalse: [
		(interpreterProxy isWords: valOop) ifTrue: [
			isValVector _ true
		] ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	size _ interpreterProxy slotSizeOf: xOop.
	(interpreterProxy slotSizeOf: yOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: headingOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: pOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	isValVector ifTrue: [
		(interpreterProxy slotSizeOf: valOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	].

	pArray _ interpreterProxy firstIndexableField: pOop.
	xArray _ interpreterProxy firstIndexableField: xOop.
	yArray _ interpreterProxy firstIndexableField: yOop.
	headingArray _ interpreterProxy firstIndexableField: headingOop.
	isValVector ifTrue: [
		valArray _ interpreterProxy firstIndexableField: valOop.
	] ifFalse: [
		val _ interpreterProxy floatValueOf: valOop
	].

	0 to: size -1 do: [:i |
		(pArray at: i) = 1 ifTrue: [
			isValVector ifTrue: [
				dist _ valArray at: i.
			] ifFalse: [
				dist _ val.
			].
			newX _ (xArray at: i) + (dist * (headingArray at: i) cos).
			newY _ (yArray at: i) - (dist * (headingArray at: i) sin).
			self scalarXAt: i xArray: xArray headingArray: headingArray value: newX destWidth: destWidth leftEdgeMode: leftEdgeMode rightEdgeMode: rightEdgeMode.
			self scalarYAt: i yArray: yArray headingArray: headingArray value: newY destHeight: destHeight topEdgeMode: topEdgeMode bottomEdgeMode: bottomEdgeMode
		].
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 11.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
primUpHill

	| sniffRange height width bitsOop tH tY tX bits turtleX turtleY startX endX startY endY maxVal maxValX rowOffset thisVal maxValY ret |
	self inline: true.
	self export: true.

	self var: 'bits' declareC: 'unsigned int *bits'.
	self var: 'tX' declareC: 'double tX'.
	self var: 'tY' declareC: 'double tY'.
	self var: 'tH' declareC: 'double tH'.

	sniffRange _ interpreterProxy stackIntegerValue: 0.
	height _ interpreterProxy stackIntegerValue: 1.
	width _ interpreterProxy stackIntegerValue: 2.
	bitsOop _ interpreterProxy stackValue: 3.
	tH _ interpreterProxy stackFloatValue: 4.
	tY _ interpreterProxy stackFloatValue: 5.
	tX _ interpreterProxy stackFloatValue: 6.

	interpreterProxy failed ifTrue: [^ nil].
	(interpreterProxy isWords: bitsOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: bitsOop) ~= (height * width) ifTrue: [interpreterProxy primitiveFail. ^ nil].

	bits _ interpreterProxy firstIndexableField: bitsOop.

	turtleX _ self cCode: 'tX' inSmalltalk: [tX asInteger].
	turtleY _ self cCode: 'tY' inSmalltalk: [tY asInteger].
	turtleX _ turtleX max: 0.
	turtleY _ turtleY max: 0.
	turtleX _ turtleX min: width - 1.
	turtleY _ turtleY min: height - 1.
	startX _ turtleX - sniffRange max: 0.
	endX _ (turtleX + sniffRange) min: (width - 1).
	startY _ (turtleY - sniffRange) max: 0.
	endY _ (turtleY + sniffRange) min: (height - 1).
	maxVal _ bits at: turtleY * width + turtleX.
	maxValX _ -1.
	startY to: endY do: [:y | 
		rowOffset _ y * width.
		startX to: endX do: [:x | 
			thisVal _ bits at: rowOffset + x.
			thisVal > maxVal ifTrue: [
				maxValX _ x.
				maxValY _ y.
				maxVal _ thisVal
			].
		].
	].
	-1 = maxValX
		ifTrue: [ret _ self radiansToDegrees: tH]
		ifFalse: [
			ret _ (self degreesFromX: (self cCoerce: maxValX - turtleX to: 'double') y: (self cCoerce: maxValY - turtleY to: 'double')) + 90.0.
		].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 8.
	interpreterProxy pushFloat: ret.

! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
radiansToDegrees: radians

	| deg degrees |
	self inline: true.
	self returnTypeC: 'double'.
	self var: 'degrees' declareC: 'double degrees'.
	self var: 'deg' declareC: 'double deg'.
	self var: 'radians' declareC: 'double radians'.
	self var: 'headingRadians' declareC: 'double headingRadians'.

	degrees _ radians / 0.0174532925199433.
	deg _ 90.0 - degrees.
	deg > 0.0 ifFalse: [deg _ deg + 360.0].
	^ deg.

! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
randomIntoFloatArray

	| range factor floatArrayOop to from size floatArray |
	self export: true.
	self inline: true.
	self var: 'factor' declareC: 'double factor'.
	self var: 'floatArray' declareC: 'float *floatArray'.

	factor _ interpreterProxy stackFloatValue: 0.
	floatArrayOop _ interpreterProxy stackValue: 1.
	to _ interpreterProxy stackIntegerValue: 2.
	from _ interpreterProxy stackIntegerValue: 3.
	range _ interpreterProxy stackIntegerValue: 4.
	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: floatArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	size _ interpreterProxy stSizeOf: floatArrayOop.
	(size >= to and: [from >= 1 and: [to >= from]]) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	floatArray _ interpreterProxy firstIndexableField: floatArrayOop.
	interpreterProxy failed ifTrue: [^ nil].

	from to: to do: [:index |
		floatArray at: index-1 put: (self cCoerce: (self kedamaRandom2: range) to: 'double') * factor.
	].

	interpreterProxy pop: 5.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
randomIntoIntegerArray

	| range factor integerArrayOop to from size integerArray |
	self export: true.
	self inline: true.
	self var: 'factor' declareC: 'double factor'.
	self var: 'integerArray' declareC: 'unsigned int *integerArray'.

	factor _ interpreterProxy stackFloatValue: 0.
	integerArrayOop _ interpreterProxy stackValue: 1.
	to _ interpreterProxy stackIntegerValue: 2.
	from _ interpreterProxy stackIntegerValue: 3.
	range _ interpreterProxy stackIntegerValue: 4.
	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: integerArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	size _ interpreterProxy stSizeOf: integerArrayOop.
	(size >= to and: [from >= 1 and: [to >= from]]) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	integerArray _ interpreterProxy firstIndexableField: integerArrayOop.
	interpreterProxy failed ifTrue: [^ nil].

	from to: to do: [:index |
		integerArray at: index-1 put: (self cCoerce: ((self cCoerce: (self kedamaRandom2: range) to: 'double') * factor) to: 'int').
	].

	interpreterProxy pop: 5.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
randomRange

	| range ret |
	self export: true.
	self inline: true.
	range _ interpreterProxy stackIntegerValue: 0.
	interpreterProxy failed ifTrue: [^ nil].

	ret _ self kedamaRandom2: range.

	interpreterProxy failed ifTrue: [^ nil].

	interpreterProxy pop: 2.
	interpreterProxy pushInteger: ret.
	^ self.

	! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
scalarGetAngleTo

	| fromY fromX toY toX x y r |
	self export: true.
	self inline: true.
	self var: 'toX' declareC: 'double toX'.
	self var: 'toY' declareC: 'double toY'.
	self var: 'fromX' declareC: 'double fromX'.
	self var: 'fromY' declareC: 'double fromY'.
	self var: 'x' declareC: 'double x'.
	self var: 'y' declareC: 'double y'.
	self var: 'r' declareC: 'double r'.

	fromY _ interpreterProxy stackFloatValue: 0.
	fromX _ interpreterProxy stackFloatValue: 1.
	toY _ interpreterProxy stackFloatValue: 2.
	toX _ interpreterProxy stackFloatValue: 3.

	interpreterProxy failed ifTrue: [^ nil].

	x _ toX - fromX.
	y _ toY - fromY.

	r _ self degreesFromX: x y: y.
	r _ r + 90.0.
	r > 360.0 ifTrue: [r _ r - 360.0].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 5.
	interpreterProxy pushFloat: r.

! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
scalarGetDistanceTo

	| fromY fromX toY toX x y r |
	self export: true.
	self inline: true.
	self var: 'toX' declareC: 'double toX'.
	self var: 'toY' declareC: 'double toY'.
	self var: 'fromX' declareC: 'double fromX'.
	self var: 'fromY' declareC: 'double fromY'.
	self var: 'x' declareC: 'double x'.
	self var: 'y' declareC: 'double y'.
	self var: 'r' declareC: 'double r'.

	fromY _ interpreterProxy stackFloatValue: 0.
	fromX _ interpreterProxy stackFloatValue: 1.
	toY _ interpreterProxy stackFloatValue: 2.
	toX _ interpreterProxy stackFloatValue: 3.

	interpreterProxy failed ifTrue: [^ nil].

	x _ fromX - toX.
	y _ fromY - toY.

	r _ ((x * x) + (y * y)) sqrt.

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 5.
	interpreterProxy pushFloat: r.

! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
scalarXAt: index xArray: xArray headingArray: headingArray value: val destWidth: destWidth leftEdgeMode: leftEdgeMode rightEdgeMode: rightEdgeMode

	| newX headingRadians |
	self inline: true.

	self var: 'xArray' declareC: 'float* xArray'.
	self var: 'headingArray' declareC: 'float* headingArray'.
	self var: 'destWidth' declareC: 'double destWidth'.
	self var: 'val' declareC: 'double val'.
	self var: 'newX' declareC: 'double newX'.
	self var: 'headingRadians' declareC: 'double headingRadians'.

	newX _ val.
	newX < 0.0 ifTrue: [
		leftEdgeMode = 1 ifTrue: [
			"wrap"
			newX _ newX + destWidth.
		].
		leftEdgeMode = 2 ifTrue: [
			"stick"
			newX _ 0.0.
		].
		leftEdgeMode = 3 ifTrue: [
			"bounce"
			newX _ 0.0 - newX.
			headingRadians _ headingArray at: index.
			headingRadians <  3.141592653589793
				ifTrue: [headingArray at: index put: 3.141592653589793 - headingRadians]
				ifFalse: [headingArray at: index put: 9.42477796076938 - headingRadians].
		].
	].

	newX >= destWidth ifTrue: [
		rightEdgeMode = 1 ifTrue: [
			newX _ newX - destWidth.
		].
		rightEdgeMode = 2 ifTrue: [
			newX _ destWidth - 0.000001.
		].
		rightEdgeMode = 3 ifTrue: [
			newX _ (destWidth - 0.000001) - (newX - destWidth).
			headingRadians _ headingArray at: index.
			headingRadians < 3.141592653589793
				ifTrue: [headingArray at: index put: (3.141592653589793 - headingRadians)]
				ifFalse: [headingArray at: index put: (9.42477796076938 - headingRadians)].
		]
	].
	xArray at: index put: newX.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
scalarYAt: index yArray: yArray headingArray: headingArray value: val destHeight: destHeight topEdgeMode: topEdgeMode bottomEdgeMode: bottomEdgeMode

	| newY |
	self inline: true.

	self var: 'yArray' declareC: 'float* yArray'.
	self var: 'headingArray' declareC: 'float* headingArray'.
	self var: 'destHeight' declareC: 'double destHeight'.
	self var: 'val' declareC: 'double val'.
	self var: 'newY' declareC: 'double newY'.

	newY _ val.
	newY < 0.0 ifTrue: [
		topEdgeMode = 1 ifTrue: [
			"wrap"
			newY _ newY + destHeight.
		].
		topEdgeMode = 2 ifTrue: [
			"stick"
			newY _ 0.0.
		].
		topEdgeMode = 3 ifTrue: [
			"bounce"
			newY _ 0.0 - newY.
			headingArray at: index put: (6.283185307179586 - (headingArray at: index)).
		].
	].

	newY >= destHeight ifTrue: [
		bottomEdgeMode = 1 ifTrue: [
			newY _ newY - destHeight.
		].
		bottomEdgeMode = 2 ifTrue: [
			newY _ destHeight - 0.000001.
		].
		bottomEdgeMode = 3 ifTrue: [
			newY _ (destHeight - 0.000001) - (newY - destHeight).
			headingArray at: index put: (6.283185307179586 - (headingArray at: index)).
		]
	].
	yArray at: index put: newY.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 15:03'!
setHeadingArrayFrom

	| resultOop headingOop size headingArray resultArray heading isValVector pOop pArray |
	self export: true.
	self inline: true.
	self var: 'pArray' declareC: 'unsigned char *pArray'.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'resultArray' declareC: 'float *resultArray'.
	self var: 'heading' declareC: 'double heading'.

	resultOop _ interpreterProxy stackValue: 0.
	headingOop _ interpreterProxy stackValue: 1.
	pOop _ interpreterProxy stackValue: 2.
	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isBytes: pOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	size _ interpreterProxy slotSizeOf: headingOop.
	(interpreterProxy isFloatObject: resultOop) ifTrue: [
		isValVector _ false.
	] ifFalse: [
		(interpreterProxy isWords: resultOop) ifTrue: [
			(interpreterProxy slotSizeOf: resultOop) ~= size
				ifTrue: [interpreterProxy primitiveFail. ^ nil].
			isValVector _ true
		] ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	pArray _ interpreterProxy firstIndexableField: pOop.
	headingArray _ interpreterProxy firstIndexableField: headingOop.
	isValVector ifTrue: [
		resultArray _ interpreterProxy firstIndexableField: resultOop.
	] ifFalse: [
		heading _ interpreterProxy floatValueOf: resultOop.
		heading _ self degreesToRadians: heading.
	].

	0 to: size - 1 do: [:i |
		(pArray at: i) = 1 ifTrue: [
			isValVector ifTrue: [
				heading _ resultArray at: i.
				heading _ self degreesToRadians: heading.
			].
			headingArray at: i put: heading.
		].
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 3.

	! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
setScalarHeading

	| headingOop headingArray heading index |
	self export: true.
	self inline: true.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'heading' declareC: 'double heading'.

	heading _ interpreterProxy stackFloatValue: 0.
	headingOop _ interpreterProxy stackValue: 1.
	index _ interpreterProxy stackIntegerValue: 2.
	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	(interpreterProxy slotSizeOf: headingOop) < index ifTrue: [interpreterProxy primitiveFail. ^ nil].

	headingArray _ interpreterProxy firstIndexableField: headingOop.

	headingArray at: index - 1 put: (self degreesToRadians: heading).

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 3.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
shutdownModule

	self export: true.
	^ true.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
turtleScalarSetX

	| xArray headingArray val destWidth xOop headingOop leftEdgeMode rightEdgeMode xIndex size |
	self export: true.
	self inline: true.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'val' declareC: 'double val'.
	self var: 'destWidth' declareC: 'double destWidth'.

	rightEdgeMode _ interpreterProxy stackIntegerValue: 0.
	leftEdgeMode _ interpreterProxy stackIntegerValue: 1.
	destWidth _ interpreterProxy stackFloatValue: 2.
	val _ interpreterProxy stackFloatValue: 3.
	headingOop _ interpreterProxy stackValue: 4.
	xIndex _ interpreterProxy stackIntegerValue: 5.
	xOop _ interpreterProxy stackValue: 6.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: xOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: xOop.
	(interpreterProxy slotSizeOf: headingOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	xArray _ interpreterProxy firstIndexableField: xOop.
	headingArray _ interpreterProxy firstIndexableField: headingOop.

	self scalarXAt: xIndex - 1 xArray: xArray headingArray: headingArray value: val destWidth: destWidth leftEdgeMode: leftEdgeMode rightEdgeMode: rightEdgeMode.
	
	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 7.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
turtleScalarSetY

	| yArray headingArray val destHeight yOop headingOop size yIndex topEdgeMode bottomEdgeMode |
	self export: true.
	self inline: true.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'val' declareC: 'double val'.
	self var: 'destHeight' declareC: 'double destHeight'.

	bottomEdgeMode _ interpreterProxy stackIntegerValue: 0.
	topEdgeMode _ interpreterProxy stackIntegerValue: 1.
	destHeight _ interpreterProxy stackFloatValue: 2.
	val _ interpreterProxy stackFloatValue: 3.
	headingOop _ interpreterProxy stackValue: 4.
	yIndex _ interpreterProxy stackIntegerValue: 5.
	yOop _ interpreterProxy stackValue: 6.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: yOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy slotSizeOf: yOop.
	(interpreterProxy slotSizeOf: headingOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	yArray _ interpreterProxy firstIndexableField: yOop.
	headingArray _ interpreterProxy firstIndexableField: headingOop.

	self scalarYAt: yIndex - 1 yArray: yArray headingArray: headingArray value: val destHeight: destHeight topEdgeMode: topEdgeMode bottomEdgeMode: bottomEdgeMode.

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 7.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 1/20/2006 22:05'!
turtlesSetX

	| xArray headingArray valArray val destWidth xOop headingOop valOop leftEdgeMode rightEdgeMode isValVector size newX pOop pArray isWordVector wordValArray |
	self export: true.
	self inline: true.
	
	self var: 'pArray' declareC: 'unsigned char *pArray'.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'valArray' declareC: 'float *valArray'.
	self var: 'wordValArray' declareC: 'unsigned int *wordValArray'.
	self var: 'val' declareC: 'double val'.
	self var: 'destWidth' declareC: 'double destWidth'.
	self var: 'newX' declareC: 'double newX'.

	rightEdgeMode _ interpreterProxy stackIntegerValue: 0.
	leftEdgeMode _ interpreterProxy stackIntegerValue: 1.
	destWidth _ interpreterProxy stackFloatValue: 2.
	valOop _ interpreterProxy stackValue: 3.
	headingOop _ interpreterProxy stackValue: 4.
	xOop _ interpreterProxy stackValue: 5.
	pOop _ interpreterProxy stackValue: 6.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isBytes: pOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isFloatObject: valOop) ifTrue: [
		isValVector _ false
	] ifFalse: [
		(interpreterProxy isWords: valOop) ifTrue: [
			isValVector _ true.
			isWordVector _ interpreterProxy is: valOop MemberOf: 'WordArray'.
		] ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	size _ interpreterProxy slotSizeOf: xOop.
	(interpreterProxy slotSizeOf: pOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: headingOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	isValVector ifTrue: [
		(interpreterProxy slotSizeOf: valOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	].

	pArray _ interpreterProxy firstIndexableField: pOop.
	xArray _ interpreterProxy firstIndexableField: xOop.
	headingArray _ interpreterProxy firstIndexableField: headingOop.
	isValVector ifTrue: [
		isWordVector ifTrue: [
			wordValArray _ interpreterProxy firstIndexableField: valOop.
		] ifFalse: [
			valArray _ interpreterProxy firstIndexableField: valOop.
		].
	] ifFalse: [
		val _ interpreterProxy floatValueOf: valOop
	].

	0 to: size - 1 do: [:i |
		(pArray at: i) = 1 ifTrue: [
			isValVector ifTrue: [
				isWordVector ifTrue: [
					newX _ wordValArray at: i.
					self cCode: '' inSmalltalk: [newX _ newX asFloat].
				] ifFalse: [
					newX _ valArray at: i.
				].
			] ifFalse: [
				newX _ val.
			].
			self scalarXAt: i xArray: xArray headingArray: headingArray value: newX destWidth: destWidth leftEdgeMode: leftEdgeMode rightEdgeMode: rightEdgeMode.
		].
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 7.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 1/20/2006 22:03'!
turtlesSetY

	| yArray headingArray valArray val destHeight yOop headingOop valOop topEdgeMode bottomEdgeMode isValVector size newY pOop pArray isWordVector wordValArray |
	self export: true.
	self inline: true.
	self var: 'pArray' declareC: 'unsigned char *pArray'.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'headingArray' declareC: 'float *headingArray'.
	self var: 'valArray' declareC: 'float *valArray'.
	self var: 'wordValArray' declareC: 'unsigned int *wordValArray'.
	self var: 'val' declareC: 'double val'.
	self var: 'destHeight' declareC: 'double destHeight'.
	self var: 'newY' declareC: 'double newY'.

	bottomEdgeMode _ interpreterProxy stackIntegerValue: 0.
	topEdgeMode _ interpreterProxy stackIntegerValue: 1.
	destHeight _ interpreterProxy stackFloatValue: 2.
	valOop _ interpreterProxy stackValue: 3.
	headingOop _ interpreterProxy stackValue: 4.
	yOop _ interpreterProxy stackValue: 5.
	pOop _ interpreterProxy stackValue: 6.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isBytes: pOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: headingOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isFloatObject: valOop) ifTrue: [
		isValVector _ false
	] ifFalse: [
		(interpreterProxy isWords: valOop) ifTrue: [
			isValVector _ true.
			isWordVector _ interpreterProxy is: valOop MemberOf: 'WordArray'.
		] ifFalse: [
			interpreterProxy primitiveFail. ^ nil
		].
	].

	size _ interpreterProxy slotSizeOf: yOop.
	(interpreterProxy slotSizeOf: pOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy slotSizeOf: headingOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	isValVector ifTrue: [
		(interpreterProxy slotSizeOf: valOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	].

	pArray _ interpreterProxy firstIndexableField: pOop.
	yArray _ interpreterProxy firstIndexableField: yOop.
	headingArray _ interpreterProxy firstIndexableField: headingOop.
	isValVector ifTrue: [
		isWordVector ifTrue: [
			wordValArray _ interpreterProxy firstIndexableField: valOop.
		] ifFalse: [
			valArray _ interpreterProxy firstIndexableField: valOop.
		].
	] ifFalse: [
		val _ interpreterProxy floatValueOf: valOop
	].

	0 to: size - 1 do: [:i |
		(pArray at: i) = 1 ifTrue: [
			isValVector ifTrue: [
				isWordVector ifTrue: [
					newY _ wordValArray at: i.
					self cCode: '' inSmalltalk: [newY _ newY asFloat].
				] ifFalse: [
					newY _ valArray at: i.
				].
			] ifFalse: [
				newY _ val.
			].
			self scalarYAt: i yArray: yArray headingArray: headingArray value: newY destHeight: destHeight topEdgeMode: topEdgeMode bottomEdgeMode: bottomEdgeMode.
		].
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 7.
! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
vectorGetAngleTo

	| x y resultOop yArrayOop xArrayOop pYOop pXOop size isVector result xArray yArray pX pY ppx ppy r |
	self export: true.
	self inline: true.
	self var: 'x' declareC: 'double x'.
	self var: 'y' declareC: 'double y'.
	self var: 'result' declareC: 'float *result'.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'pX' declareC: 'float *pX'.
	self var: 'pY' declareC: 'float *pY'.
	self var: 'ppx' declareC: 'double ppx'.
	self var: 'ppy' declareC: 'double ppy'.

	resultOop _ interpreterProxy stackValue: 0.
	yArrayOop _ interpreterProxy stackValue: 1.
	xArrayOop _ interpreterProxy stackValue: 2.
	pYOop _ interpreterProxy stackValue: 3.
	pXOop _ interpreterProxy stackValue: 4.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: resultOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy stSizeOf: resultOop.
	size < 0 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy stSizeOf: xArrayOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy stSizeOf: yArrayOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	(interpreterProxy isFloatObject: pXOop) ifTrue: [
		(interpreterProxy isFloatObject: pYOop)
			ifTrue: [isVector _ false]
			ifFalse: [interpreterProxy primitiveFail. ^ nil].

	] ifFalse: [
		(interpreterProxy isFloatObject: pYOop)
			ifFalse: [isVector _ true]
			ifTrue: [interpreterProxy primitiveFail. ^ nil].
	].

	isVector ifTrue: [
		(interpreterProxy stSizeOf: pXOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
		(interpreterProxy stSizeOf: pYOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	].

	result _ interpreterProxy firstIndexableField: resultOop.
	xArray _ interpreterProxy firstIndexableField: xArrayOop.
	yArray _ interpreterProxy firstIndexableField: yArrayOop.
	isVector ifTrue: [
		pX _ interpreterProxy firstIndexableField: pXOop.
		pY _ interpreterProxy firstIndexableField: pYOop.
	].

	isVector ifFalse: [
		ppx _ interpreterProxy floatValueOf: pXOop.
		ppy _ interpreterProxy floatValueOf: pYOop.
	].

	0 to: size - 1 do: [:index |
		isVector ifTrue: [
			ppx _ pX at: index.
			ppy _ pY at: index.
		].

		x _ ppx - (xArray at: index).
		y _ ppy - (yArray at: index).
		r _ self degreesFromX: x y: y.
		r _ r + 90.0.
		r > 360.0 ifTrue: [r _ r - 360.0].

		result at: index put: r.
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 6.
	interpreterProxy push: resultOop.

! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
vectorGetDistanceTo

	| x y resultOop yArrayOop xArrayOop pYOop pXOop size isVector result xArray yArray pX pY ppx ppy |
	self export: true.
	self inline: true.
	self var: 'x' declareC: 'double x'.
	self var: 'y' declareC: 'double y'.
	self var: 'result' declareC: 'float *result'.
	self var: 'xArray' declareC: 'float *xArray'.
	self var: 'yArray' declareC: 'float *yArray'.
	self var: 'pX' declareC: 'float *pX'.
	self var: 'pY' declareC: 'float *pY'.
	self var: 'ppx' declareC: 'double ppx'.
	self var: 'ppy' declareC: 'double ppy'.

	resultOop _ interpreterProxy stackValue: 0.
	yArrayOop _ interpreterProxy stackValue: 1.
	xArrayOop _ interpreterProxy stackValue: 2.
	pYOop _ interpreterProxy stackValue: 3.
	pXOop _ interpreterProxy stackValue: 4.

	interpreterProxy failed ifTrue: [^ nil].

	(interpreterProxy isWords: resultOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: xArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy isWords: yArrayOop) ifFalse: [interpreterProxy primitiveFail. ^ nil].

	size _ interpreterProxy stSizeOf: resultOop.
	size < 0 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy stSizeOf: xArrayOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	(interpreterProxy stSizeOf: yArrayOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].

	(interpreterProxy isFloatObject: pXOop) ifTrue: [
		(interpreterProxy isFloatObject: pYOop)
			ifTrue: [isVector _ false]
			ifFalse: [interpreterProxy primitiveFail. ^ nil].

	] ifFalse: [
		(interpreterProxy isFloatObject: pYOop)
			ifFalse: [isVector _ true]
			ifTrue: [interpreterProxy primitiveFail. ^ nil].
	].

	isVector ifTrue: [
		(interpreterProxy stSizeOf: pXOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
		(interpreterProxy stSizeOf: pYOop) ~= size ifTrue: [interpreterProxy primitiveFail. ^ nil].
	].

	result _ interpreterProxy firstIndexableField: resultOop.
	xArray _ interpreterProxy firstIndexableField: xArrayOop.
	yArray _ interpreterProxy firstIndexableField: yArrayOop.
	isVector ifTrue: [
		pX _ interpreterProxy firstIndexableField: pXOop.
		pY _ interpreterProxy firstIndexableField: pYOop.
	].

	isVector ifFalse: [
		ppx _ interpreterProxy floatValueOf: pXOop.
		ppy _ interpreterProxy floatValueOf: pYOop.
	].

	0 to: size - 1 do: [:index |
		isVector ifTrue: [
			ppx _ pX at: index.
			ppy _ pY at: index.
		].

		x _ ppx - (xArray at: index).
		y _ ppy - (yArray at: index).
		result at: index put: ((x * x) + (y * y)) sqrt.
	].

	interpreterProxy failed ifTrue: [^ nil].
	interpreterProxy pop: 6.
	interpreterProxy push: resultOop.

! !

!KedamaPlugin2 methodsFor: 'primitives' stamp: 'yo 10/13/2005 01:28'!
zoomBitmap

	| yFactor xFactor sHeight sWidth dst src srcSize dstSize sOrigin dOrigin srcIndex bit dstIndex srcOrigin |

	self export: true.
	self inline: true.
	self var: 'sOrigin' declareC: 'unsigned int* sOrigin'.
	self var: 'dOrigin' declareC: 'unsigned int* dOrigin'.

	yFactor _ interpreterProxy stackIntegerValue: 0.
	xFactor _ interpreterProxy stackIntegerValue: 1.
	sHeight _ interpreterProxy stackIntegerValue: 2.
	sWidth _ interpreterProxy stackIntegerValue: 3.
	dst _ interpreterProxy stackValue: 4.
	src _ interpreterProxy stackValue: 5.

	interpreterProxy failed ifTrue: [^ nil].

	srcSize _ interpreterProxy slotSizeOf: src.
	dstSize _ interpreterProxy slotSizeOf: dst.

	(sWidth * sHeight) = srcSize ifFalse: [interpreterProxy primitiveFail. ^ nil].
	(srcSize * xFactor * yFactor) = dstSize ifFalse: [interpreterProxy primitiveFail. ^ nil].

	sOrigin _ interpreterProxy firstIndexableField: src.
	dOrigin _ interpreterProxy firstIndexableField: dst.

	srcIndex _ 0.
	srcOrigin _ 0.
	dstIndex _ 0.
	0 to: sHeight - 1 do: [:sy |
		0 to: yFactor - 1 do: [:y |
			0 to: sWidth - 1 do: [:sx |
				bit _ sOrigin at: srcIndex.
				srcIndex _ srcIndex + 1.
				0 to: xFactor - 1 do: [:dummy |
					dOrigin at: dstIndex put: bit.
					dstIndex _ dstIndex + 1.
				].
			].
			srcIndex _ srcOrigin.
		].
		srcOrigin _ srcOrigin + sWidth.
		srcIndex _ srcOrigin.
	].

	interpreterProxy pop: 6.
! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

KedamaPlugin2 class
	instanceVariableNames: ''!

!KedamaPlugin2 class methodsFor: 'as yet unclassified' stamp: 'yo 10/13/2005 01:29'!
declareCVarsIn: cg

	cg var: #kedamaRandomSeed type: 'unsigned int'.
	cg var: #randA type: 'unsigned int'.
	cg var: #randM type: 'unsigned int'.
	cg var: #randQ type: 'unsigned int'.
	cg var: #randR type: 'unsigned int'.
! !
